﻿// DESCRIPTION:  Populate Feedback form.
// MODIFIED:     29 June 2021
// VERSION:      FTFS 1.8
// 
// © Copyright 2017-2021 Micro Focus or one of its affiliates.
//
// The only warranties for products and services of Micro Focus and its affiliates and licensors 
// (“Micro Focus”) are as may be set forth in the express warranty statements accompanying such 
// products and services. Nothing herein should be construed as constituting an additional warranty. 
// Micro Focus shall not be liable for technical or editorial errors or omissions contained herein. 
// The information contained herein is subject to change without notice.

(function () {
    
    function getTopicPath()
    {
        // Extracts the path of the topic
        // When running in a .CHM help file, document.URL seems to be something like:
        // ...PathOfMyHelpFile.chm::/Folder/File.htm
        var topicURL = document.URL;
        
        var regexCHM = /\.chm::\/(.+)/i;
        var regexHTML5 = /\/content\/(.+\.html?)/i;
        
        if (regexCHM.test(topicURL))
        {
            var match = topicURL.match(regexCHM);
            topicURL = match[1];
        }
        else if (regexHTML5.test(topicURL))
        {
            var match = topicURL.match(regexHTML5);
            topicURL = match[1];
        }
        else
        {
            // web-based without Content folder?
            var index = topicURL.lastIndexOf("/");
            topicURL = topicURL.substring(index + 1);
        }
        
        // Strip any query parameters after file name
        var index = topicURL.indexOf("?");
        if (index > -1)
            topicURL = topicURL.substring(0, index);
        
        return topicURL;
    }
    
    function initFeedback(event)
    {
        var feedbackVariables = document.getElementById("ft-feedbackDiv");
        var productFamily = feedbackVariables.getAttribute("data-product-family");
        var productName = feedbackVariables.getAttribute("data-product-name");
        var productVersion = feedbackVariables.getAttribute("data-product-version");
        var commentsEmailAddress = feedbackVariables.getAttribute("data-comments-email");
        var firstheading = feedbackVariables.getAttribute("data-topic-title");
        
        // Prepend product family if not included in product name
        if (productName.toLowerCase().substring(0, productFamily.length) !== productFamily.toLowerCase())
        {
            productName = productFamily + " " + productName;
        }
        
        var topicURL = getTopicPath();
        
        // Localizable
        document.getElementById('ft-feedbackURL').textContent = 'Help Topic: ' + topicURL;
        var emailSubject = 'Feedback on ' + productName + " " + productVersion + ' documentation: ' + firstheading;
        var emailBody = 'Product: ' + productName + ' ' + productVersion + '\r\n\r\nTopic Title: ' + firstheading + '\r\n\r\nHelp Topic: ' + topicURL + '\r\n\r\nFeedback:\r\n';
        document.getElementById('ft-feedbackOpen').href = 'mailto:' + commentsEmailAddress + '?subject=' + encodeURIComponent(emailSubject) + '&body=' + encodeURIComponent(emailBody);
        
        document.getElementById('ft-CloseFeedbackBox').addEventListener('click', closeFeedback);
        document.getElementById('ft-OpenFeedbackBox').addEventListener('click', openFeedback);
    }
    
    function openFeedback(event)
    {
        document.getElementById('ft-feedbackDiv').classList.add("visible");
    }
    
    function closeFeedback(event)
    {
        document.getElementById('ft-feedbackDiv').classList.remove("visible");
    }
    
    document.addEventListener('DOMContentLoaded', initFeedback)
})();